\version "2.24.0"
\language "deutsch"

\paper {
  system-system-spacing = #'((basic-distance . 17))
  markup-system-spacing = #'((basic-distance . 20))
  left-margin = 1.5\cm
  line-width = 18.7\cm
  print-page-number = false
  top-margin = 10\mm
  bottom-margin = 5\mm
  %ragged-last-bottom=##f
  %system-count = #3
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Când a fost să moară Ștefan"
  subtitle = " "
  poet = "Șt. O. Iosif (1875 - 1913)"
  composer = "melodie tradițională"
  %composer = \markup \center-column { "Călin Buzilă" \small "19 august 2013" }
  %meter = "Moderato"
  tagline=""
}

global = {
  \key g \major
  %\partial 2
  \time 12/8
  \set Staff.midiInstrument = "clarinet"
}

womenWordsOne = \lyricmode {
  \set stanza = "1."
  Când a fost să moa -- ră Şte -- fan,
  mul -- tă ja -- le-a fost în ţa -- ră;
  și __ la pa -- tul lui de moar -- te
  toţi __ bo -- ie -- rii s-a -- du -- na -- ră,
  și __ la pa -- tul lui de moar -- te
  toţi __ bo -- ie -- rii s-a -- du -- na -- ră.
}

womenWordsTwo = \lyricmode {
  \set stanza = "2."
  Cu __ un dan -- găt plin de ja -- le
  mii __ de clo -- po -- te dau ves -- te:
  Şte -- fan Vo -- dă al Mol -- do -- vei,
  Şte -- fan Vo -- dă nu mai es -- te,
  Şte -- fan Vo -- dă al Mol -- do -- vei,
  Şte -- fan Vo -- dă nu mai es -- te.  
}

womenWordsThree = \lyricmode {
  \set stanza = "3."
  Tris -- tă-i mă -- năs -- ti -- rea Put -- na,
  por -- ţi -- le des -- chi -- se-aş -- teap -- tă
  stră -- lu -- cit con -- voi ce vi -- ne
  și __ spre ea în -- cet se-n -- dreap -- tă,
  stră -- lu -- cit con -- voi ce vi -- ne
  și __ spre ea în -- cet se-n -- dreap -- tă.
}

menWords = \lyricmode {
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 \skip 1 \skip 1 
  \skip 1 \skip 1 \skip 1 
  
}
  
sopMusic = \relative c'' {
  g4.( g4) fis8 g4 fis8 g4 a8 h2. h
  d4.( d4) c8 c4 h8 d4 c8 h2. h
  r4. h4 d8 c4 h8 h4 a8 a4 g8 a4.( a4) 
  c8 h4 a8 
  \partial 4.
  g4 fis8 g4.( a) h2.
  h4.( h4) d8 c4 h8 h4 a8 a4 g8 a4.( a4) 
  c8 h4 a8 
  \partial 4.
  g4 fis8 g2. g
  \bar "|."
}

altMusic = \relative c'' {
  g4.( g4) fis8 g4 fis8 g4 fis8 g2. g
  h4.( h4) a8 a4 g8 h4 a8 g2. g
  g4.( g4) h8 a4 g8 g4 fis8 fis4 g8
  fis4.( fis4) a8 g4 fis8 g4 
  fis8 g4.( fis) g2.
  g4.( g4) h8 a4 g8 g4 fis8 fis4 e8
  fis4.( fis4) a8 g4 fis8 e4 
  d8 e2. e  
}

bassMusic = \relative c' {
  g4.( g4) fis8 g4 d8 d4 d8 g2. g
  g4.( g4) g8 g4 c,8 c4 c8 g'2. g
  r1*12/8 r r4. r1*12/8
  g4.( g4) g8 c,4 c8 d4 d8 d4 d8
  d4.( d4) d8 d4 d8 d4 d8 c2. c  
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
     \new Voice { \voiceOne \global \sopMusic }
     \new Voice { \voiceTwo \global \altMusic }
     \addlyrics { \womenWordsOne }
     \addlyrics { \womenWordsTwo }
     \addlyrics { \womenWordsThree }
    >>
    \new Staff <<
     \clef bass
     \new Voice { \global \bassMusic }
     \addlyrics { \menWords }
    >>
    >>
>>

midiOutput = \midi {
  \tempo 4 = 120
  \context { \Voice \remove "Dynamic_performer" }
}

\book {

\score {
  \myScore
  \layout { }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}

\markup {
    \large {
      \hspace #0.0
      %\vspace #1.0
      "4."
      \column {
        "Este Ştefan, azi străbate"
        "Cel din urmă drum din ţară"
        "Dar pe unde trece-acuma,"
        "În măreaţa zi de vară? "
      }
      \hspace #2.0
      "5."
      \column {
        "Plânge dealul, plânge valea,"
        "Plâng pădurile bătrâne,"
        "Şi poporu-n hohot plânge:"
        "Cui ne laşi pe noi, stăpâne?"
      }
      \hspace #3.0
      "6."
      \column {
        "Eu vă las în grija mare"
        "A lui Dumnezeu cel Sfânt,"
        "Să stati strajă la hotare,"
        "Să păziţi acest pământ!"
      }
    }
  }  

  \markup {
    \large {
      \hspace #0.0
      \vspace #2.0
      "7."
      \column {
        "Şi de veţi vedea că vine"
        "Vreun duşman nesăbuit,"
        "Să strigaţi atunci la mine,"
        "Voi sări şi din mormânt!"
      }
      \hspace #3.5
      "8."
      \column {
        "Toți copiii României"
        "Sunt din neamul lui Traian,"
        "Și în fiecare suflet"
        "Se mai naște un Ștefan."
      }
      \hspace #2.8
      "9."
      \column {
        "Jos în vale, sus pe creste,"
        "Tuturor le dați de veste:"
        "Ștefan Vodă al Moldovei,"
        "Ștefan Vodă mai trăiește!"
      }
     }
  }
}